\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{dipNSU}[2021 Шаблон курсовой работы]

\newcommand{\headlinecolor}{\normalcolor}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{extreport}}%передаёт опции класса  kurs3 базовому классу extreport 
\ProcessOptions\relax
\LoadClass{extreport}%базовый класс

%бакалаврская работа
\DeclareOption{bach}{
\def\Level{БАКАЛАВРИАТ}
\def\Program{03.03.02 ФИЗИКА}%код и название образовательной программы
\def\WorkType{ВЫПУСКНАЯ КВАЛИФИКАЦИОННАЯ РАБОТА}
\def\MagType{}}
\newcommand\MagProg[1]{\def\@MagProg{#1}}%название магистерской программы
%магистерская диссертация
\DeclareOption{magis}{
\def\Level{МАГИСТРАТУРА}
\def\Program{03.04.02 ФИЗИКА}%код и название образовательной программы
\def\WorkType{ВЫПУСКНАЯ КВАЛИФИКАЦИОННАЯ РАБОТА}
\def\MagType{Магистерская программа: \textbf{\@MagProg}}
}

\ProcessOptions\relax

\usepackage{ifxetex}%автоматически определяет какие пакеты использовать если верстается документ XeLaTeX'ом или pdfLaTeX'ом
\ifxetex%вёрстка XeLaTeX'ом
	\RequirePackage[english,russian]{babel}%языковые пакеты. Языком по-умолчанию будет последний объявленный. Отвечает за перенос слов, включает использование правил типографского набора для выбранного язык 
	\usepackage{fontspec}      %% подготавливает загрузку шрифтов Open Type, True Type и др.
	\usepackage{xecyr}
	\defaultfontfeatures{Ligatures={TeX},Renderer=Basic}  %% свойства шрифтов по умолчанию
	\setmainfont[Ligatures={TeX,Historic},Scale=.97]{Times New Roman} %% задаёт основной шрифт документа
	\setsansfont{Comic Sans MS}   %% задаёт шрифт без засечек
	\setmonofont{Courier New}%шрифт будет применяться в окружении \verb 
	%конец раздела для вёрстки XeLaTeX'ом
\else
	% default: pdfLaTeX
	%кириллические шрифты с помощью пакета pscyr
	%\RequirePackage[mat]{pscyr}
	%\renewcommand{\rmdefault}{ftm}
	\RequirePackage[utf8]{inputenc}%кодировка
	%\usepackage[T1,T2A]{fontenc}%кодировка шрифта. Для русского языка по-умолчанию будет T2A. Для латиницы можно явно указать требуемую
	\RequirePackage[english,russian]{babel}%языковые пакеты. Языком по-умолчанию будет последний объявленный. Отвечает за перенос слов, включает использование правил типографского набора для выбранного язык 
\fi
%LATEX PSCyr 	Название шрифта
%fac 	Academy
%fad 	Advertisement
%faq 	AntiquaPSCyr
%fco 	College
%fcp 	CooperPSCyr
%fer 	ERKurierPSCyr
%fha 	HandbookPSCyr
%fjn 	JournalPSCyr
%flz 	Lazurski
%fma 	MagazinePSCyr
%fsv 	SouvenirPSCyr
%ftx 	TextbookPSCyr
%far 	ArialMT
%fcr 	CourierNewPSMT
%ftm 	TimesNewRomanPSMT

\RequirePackage{geometry} % Меняем поля страницы
\geometry{left=3cm}% левое поле
\geometry{right=1.5cm}% правое поле
\geometry{top=2cm}% верхнее поле
\geometry{bottom=2cm}% нижнее поле
\linespread{1.5}%интервал
%\usepackage{setspace}%гибкая настройка межстрочного интервала
\RequirePackage{array}%массивы и таблицы
\RequirePackage{titlesec} % меняем цифры у секций
\RequirePackage{cite} % для более аккуратного цитирования (объединение в подряд идущих ссылок)
\renewcommand{\thechapter}{\arabic{chapter}}
\renewcommand{\thesection}{\arabic{chapter}.\arabic{section}}
\renewcommand{\thesubsection}{\arabic{chapter}.\arabic{section}.\arabic{subsection}}


\usepackage{fancyhdr} % пакет для установки колонтитулов
\pagestyle{fancy} % смена стиля оформления страниц
\fancyhf{}
\fancyhead{}
\fancyfoot{}
\fancyhead[CE,CO]{\thepage}
%\fancyfoot[CE,CO]{}
\renewcommand{\headrulewidth}{0pt} % убрать разделительную линию

\usepackage{indentfirst}%абзацный отступ после заголовка раздела

\renewcommand{\labelenumi}{\arabic{enumi}.}% Меняем везде перечисления на цифра.цифра
\renewcommand{\theenumii}{.\arabic{enumii}}% Меняем везде перечисления на цифра.цифра
\renewcommand{\labelenumii}{\arabic{enumi}.\arabic{enumii}.}% Меняем везде перечисления на цифра.цифра
\renewcommand{\theenumiii}{.\arabic{enumiii}}% Меняем везде перечисления на цифра.цифра
\renewcommand{\labelenumiii}{\arabic{enumi}.\arabic{enumii}.\arabic{enumiii}.}% Меняем везде перечисления на


%установить метаданные pdf файла
\newcommand\SetPDFmeta{
\makeatletter
\AtBeginDocument{
	\hypersetup{
		pdftitle = {\@title},
		pdfauthor = {\@author},
		pdfkeywords = {\@KeyWords},
	}
}
\makeatother
}
\addto\captionsrussian{%переименовать Оглавление
	\renewcommand{\contentsname}%
	{Содержание}%
}
\titleformat{\chapter}%изменить формат заголовка главы
{\normalfont\LARGE\bfseries}{\thechapter}{1em}{\thispagestyle{fancy}
	\pagestyle{fancy}
}


\bibliographystyle{ugost2008}%стиль библиографии

\addto\captionsrussian{\def\figurename{Рисунок}}%замена подписей к рисункам

\newcommand\Organization[1]{\def\@Organization{#1}}%название организации
\newcommand\OrganizationType[1]{\def\@OrganizationType{#1}}%тип организации
\newcommand\UpperOrganization[1]{\def\@UpperOrganization{#1}}%название вышестоящей организации
\newcommand\Faculty[1]{\def\@Faculty{#1}}%название факультета
\newcommand\Department[1]{\def\@Department{#1}}%название каферды
\newcommand\Format[1]{\def\@Format{#1}}%формат ВКР

\newcommand\Group[1]{\def\@Group{#1}}%номер группы
\newcommand\DepHeadDegree[1]{\def\@DepHeadDegree{#1}}%степень и звание зав. каф.
\newcommand\DepHeadWorkPlace[1]{\def\@DepHeadWorkPlace{#1}}%должность и место работы зав. каф.
\newcommand\DepHead[1]{\def\@DepHead{#1}}%Фамилия и инициалы зав. каф.


\newcommand\Superviser[1]{\def\@Superviser{#1}}%ФИО руководителя
\newcommand\SuperviserDegree[1]{\def\@SuperviserDegree{#1}}%учёная степень руководителя
\newcommand\SuperviserWorkPlace[1]{\def\@SuperviserWorkPlace{#1}}%должность и место работы руководителя

\newcommand\KeyWords[1]{\def\@KeyWords{#1}}%ключевые слова
\newcommand\InputKeyWords{Ключевые слова: \@KeyWords}%вставить ключевые слова
\newcommand\RefSource[1]{\def\@RefSource{#1}}%название файла с библиографией



\newcommand\ChapterWithoutNum[1]{{%вспомогательная команда для форматирования заголовка раздела без номера (Введение и т.п.)
		\normalfont\LARGE\bfseries\cleardoublepage\begin{center}{#1}\end{center}
		\addcontentsline{toc}{chapter}{#1}}
}

\addto{\captionsrussian}{\renewcommand{\bibname}{Список использованных источников}}%переименовать список литературы

\newcommand\References{
\addcontentsline{toc}{chapter}{\bibname}
\bibliography{\@RefSource}% библиография, несортированный гост
}




\newcommand\AbstractWithoutPage{
	{\normalfont\LARGE\bfseries\cleardoublepage\begin{center}Аннотация\end{center}}\thispagestyle{empty}\setcounter{page}{2}}%заголовок Аннотация
\newcommand\Abstract{
	{\normalfont\LARGE\bfseries\cleardoublepage\begin{center}Аннотация\end{center}}\setcounter{page}{2}}%заголовок Аннотация

\newcommand\Definitions{\ChapterWithoutNum{Определения}}%заголовок Определения с добавлением в оглавление без номера
\newcommand\Abbreviations{\ChapterWithoutNum{Сокращения и обозначения}}%заголовок Сокращения и обозначения с добавлением в оглавление без номера
\newcommand\Introduction{\ChapterWithoutNum{Введение}}%заголовок Введение с добавлением в оглавление без номера
\newcommand\Conclusion{\ChapterWithoutNum{Заключение}}%заголовок Заключение с добавлением в оглавление без номера

\newcounter{appendix}%счётчик приложений
\newcommand\Appendix{
	{\addtocounter{appendix}{1}\normalfont\LARGE\bfseries\cleardoublepage\begin{center}Приложение \Asbuk{appendix}\end{center}}
	\addcontentsline{toc}{chapter}{Приложение \Asbuk{appendix}}
	\setcounter{table}{0}
	\renewcommand{\thetable}{\Asbuk{appendix}.\arabic{table}}
	\setcounter{figure}{0}
	\renewcommand{\thefigure}{\Asbuk{appendix}.\arabic{figure}}

}%заголовок Приложение с добавлением в оглавление без номера, с увеличением счётчика


\newcommand\tline[3]{$\underset{\text{#1}}{\text{\underline{#3\hspace{#2}}}}$}%https://tex.stackexchange.com/questions/55698/text-under-a-line/55703






\renewcommand{\maketitle}{%шаблон титульного листа
	\begin{titlepage}

	\begin{center}%
		\begin{spacing}{1}
		{\headlinecolor\small\@UpperOrganization}
		\vspace{\baselineskip}
		
		
		{\small\@OrganizationType}
		\vspace{\baselineskip}
		
		{\small\@Organization}
		\end{spacing}
	%	\vspace{1\baselineskip}
	\end{center}%
	\begin{flushleft}
		\small
		Факультет: \textbf{\@Faculty}
		
		Кафедра: \textbf{\@Department}
		
		\MagType
		
		\vspace{\baselineskip}
				
		Направление подготовки: \textbf{\Program}
		
		Образовательная программа: \textbf{\Level}
		

			
	\end{flushleft}
		
	%	\vspace{\baselineskip}
		
	\begin{center}%	
		\textbf{\WorkType}

	\textbf{(\@Format)}

	\@author
	\end{center}%	
	\begin{flushleft}
	Тема работы: \@title
	\end{flushleft}
	\vfill
\begin{small}
	\begin{tabular}{>{\raggedright\arraybackslash}m{0.49\linewidth}>{\raggedleft\arraybackslash}m{0.49\linewidth}}

\textbf{<<К защите допущена>>}	& \\
И.О. заведующего кафедрой	& Научный руководитель\\
\@DepHeadDegree & \@SuperviserDegree\\
\@DepHeadWorkPlace	& \@SuperviserWorkPlace\\
&\\
 \@DepHead/\tline{(подпись, МП)}{3cm}{} & \@Superviser/\tline{(подпись, МП)}{3cm}{}\\
  &\\
<<\rule{1.cm}{0.5pt}>>\rule{2.5cm}{0.5pt} \the\year{} г.	& <<\rule{1.cm}{0.5pt}>>\rule{2.5cm}{0.5pt} \the\year{} г.\\
  &\\
 &Дата защиты: <<\rule{1.cm}{0.5pt}>>\rule{2.5cm}{0.5pt} \the\year{} г.\\
	\end{tabular}
\end{small}
	\vfill
	
	\begin{center}%
		Новосибирск --- \the\year{} г.
	\end{center}%

\end{titlepage}
\addtocounter{page}{1} 
}
